TITLE   'Parallel Plate Capacitor, One-Half'                      { exa092a.pde }
SELECT     errlim=3e-4     ngrid=1     spectral_colors
VARIABLES   U
DEFINITIONS					
   L=2     xx=0.25     d0=0.1     dd0=0.4*d0      U0=1.0e4	{ Voltage }
   eps0=8.854e-12     eps=eps0			{ Permittivity }
   Ex=-dx(U)     Ey=-dy(U)     E=-grad(U)     Em=magnitude(E)
   Dex=eps*Ex     Dey=eps*Ey     D=eps*E     Dm=magnitude(D)	
EQUATIONS
   div( D)=0	         				
BOUNDARIES
region 'domain'			
   start 'outer' (0,-d0-dd0)   natural(U)=0     		{ Outer boundary }
   line to (0,-L) to (2*L,-L)  to (2*L,L) to (0,L) to (0,d0+dd0)
   value(U)=U0  line to (xx,d0+dd0) to (xx,d0) to (0,d0)	{ Upper plate }
   natural(U)=0  line to (0,-d0)
   value(U)=0  line to (xx,-d0) to (xx,-d0-dd0) close	{ Lower plate }
region 'glass'   eps=7.0*eps0          				{ Dielectric }
   start(0,-d0)  line to (xx,-d0)  to (xx,d0) to (0,d0) close
PLOTS
   contour( U)     contour( Dm) log     contour( Dm) painted on 'glass'
   vector( D) norm elevation( Dey) from (0,0) to (2*L,0)	{ ? Charge }
END






